<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class SearchData extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		// 設定時間 Asia/Taipei
		ini_set('date.timezone','Asia/Taipei');
		$this->load->database();
        // set_time_limit(0);

	}
    // Watch JSON
    public function WatchJSON(){
        echo 'WatchJSON';
    }
    
	// 點擊頁面
	public function Index()
	{
		$switchID = $this->input->get('s');
		$domain = null;
		// $search_time = '2019-03-29 00:00:00';
		$search_time = '2019-06-01 00:00:00';
		$Stime = date('Y-m-d 00:00:00', strtotime('-7 days'));
		$Etime = date('Y-m-d 00:00:00');
		$Search_Time_Interval_Sql = " AND UpdateTime > '".$Stime."' AND  UpdateTime < '".$Etime."' ";
		$Language = array();
		$PageName = array();
		switch($switchID){
			// 來源
			case 1:
			$domain = 'world-wrist-watch.com';
			$sql = "SELECT LinkName,COUNT(ID) AS LinkCount FROM `data_statistics` WHERE NowUrl LIKE '%" . $domain ."%' AND UpdateTime > '" . $search_time . "' GROUP BY LinkName ORDER BY LinkCount DESC";
			break;
			case 2:
			$domain = 'luxurywatcher.com';
			$sql = "SELECT LinkName,COUNT(ID) AS LinkCount FROM `data_statistics` WHERE NowUrl LIKE '%" . $domain ."%' AND UpdateTime > '" . $search_time . "' GROUP BY LinkName ORDER BY LinkCount DESC";
			break;
			case 3:
			$domain = 'luxurywatcher.com';
			$sql = "SELECT NowUrl,LinkUrl,COUNT(ID) AS LinkCount FROM `data_statistics` 
			WHERE NowUrl LIKE '%" . $domain ."%' AND UpdateTime > '" . $search_time . "' 
			AND LinkName != 'Load'
			AND (
				LinkUrl Like '%Catalog/Jewelry%'
				OR LinkUrl Like '%Catalog/Watch%'
				OR LinkUrl Like '%Catalog/Motor%'
				OR LinkUrl Like '%Catalog/Living%'
				OR LinkUrl Like '%Catalog/Fashion%'
				OR LinkUrl Like '%Catalog/Lifestyle%'
			)".$Search_Time_Interval_Sql."
			GROUP BY LinkUrl,NowUrl ORDER BY LinkCount DESC";
			$PageName = array('index', 'Jewelry', 'Watch', 'Motor', 'Living', 'Fashion', 'Lifestyle');
			break;
			case 4:
			$domain = 'world-wrist-watch.com';
			$sql = "SELECT NowUrl,LinkUrl,COUNT(ID) AS LinkCount FROM `data_statistics` 
			WHERE NowUrl LIKE '%" . $domain ."%'  
			AND LinkName != 'Load'
			AND (
				LinkUrl Like '%Catalog/News%'
				OR LinkUrl Like '%Catalog/Topic%'
				OR LinkUrl Like '%Catalog/Review%'
				OR LinkUrl Like '%Catalog/Watch%'
				OR LinkUrl Like '%Catalog/Knowledge%'
				OR LinkUrl Like '%Catalog/Dictionary%'
			)".$Search_Time_Interval_Sql."
			GROUP BY LinkUrl,NowUrl ORDER BY LinkCount DESC";
			$PageName = array('index', 'News', 'Topic', 'Review', 'Watch', 'Knowledge', 'Dictionary');
			break;
			default:
			$sql = null;
			break;
		}

	
		if($sql != null){

			$query = $this->db->query($sql);
			
			$Url = Array();
			if($switchID == 3 || $switchID == 4 ){
				foreach($query->result() as $key => $row){
					if(strlen($row->NowUrl) > 0){
						$d = explode('/',rawurldecode(rawurldecode($row->NowUrl)));
						
						// 語系
						if(!in_array($d[1],$Language)) $Language[] = $d[1];

						$page = isset($d[2]) ? $d[2] : 'index';
						$type = isset($d[3]) ? $d[3] : 'index';

						$luArray = explode('://',rawurldecode(rawurldecode($row->LinkUrl)));
						$lu = explode('/', (count($luArray) > 1 ? $luArray[1] : $luArray[0]));
						$lu_type =  isset($lu[3]) ? $lu[3] : 'index';
						if(in_array($type,$PageName)){
							$Url[$d[1]][$type][$lu_type] = isset($Url[$d[1]][$type][$lu_type] ) ? intval($Url[$d[1]][$type][$lu_type]) + intval($row->LinkCount) : $row->LinkCount;
						}
					}
				}

		        $Language = [ 'zh-Hant' , 'zh-Hans' ];
		        foreach($Language as $key => $lg){
					foreach($PageName as $key => $pg){
					    
					    echo $key.' | ';
						if(in_array($pg,$PageName)){
							$TagArray = array();
							$tag_pageSql = $pg == 'index' ? " NowUrl LIKE '%" . $lg . "'" : " NowUrl LIKE '%" . $pg . "%' ";
							$tag_sql = "SELECT LinkName as tag,count(ID) as LinkCount FROM `data_statistics`
							            WHERE NowUrl LIKE '%" . $domain ."%'
							            AND " . $tag_pageSql ." 
							            AND LinkUrl LIKE '%earch/tag%' 
							            AND NowUrl LIKE '%" . $lg ."%' 
							            AND UpdateTime > '" . $search_time . "' 
            							".$Search_Time_Interval_Sql."
            							GROUP by LinkName ORDER BY LinkCount DESC";
							$tag_query = $this->db->query($tag_sql);
							foreach($tag_query->result() as $key => $row){
								$TagArray[$key]['Name'] = trim(strip_tags($row->tag));
								$TagArray[$key]['Count'] = $row->LinkCount;
							}
							$Url[$lg][$pg]['tag'] = $TagArray;
							echo '<br>';
				            // echo '<br><br><br><br><br>';
				            // echo $tag_sql;
				            if($key == 3) {print_r($Url);exit;}
						}
					}
				}
    				
				// 查詢 Domain ID 
				$DomainSQL = "SELECT Domain,ID FROM web_domain WHERE Domain = '". $domain ."'" ;
				$DomainQuery = $this->db->query($DomainSQL);
				if(isset($DomainQuery->result()[0]->Domain)){
					// 存入 API 資料
					$data = array(
						// Domain ID
						'web_domain_ID' => $DomainQuery->result()[0]->ID
						// 建立時間
						, 'UpdateTime' => date('Y-m-d H:i:s')
						// API ID
						, 'API_ID' => 1
						// API 資料查詢 開始時間
						, 'API_Stime' => $Stime
						// API 資料查詢 結束時間
						, 'API_Etime' => $Etime
						// API 資料查詢 
						, 'API_Data' => json_encode( $Url, JSON_UNESCAPED_UNICODE )
					);
					// 寫入 SQL 語法組合 & 跳脫
					$InsertSQL = $this->db->insert_string('api_data', $data);
					// 執行 SQL / 寫入資料
					$this->db->query($InsertSQL);
				}
			}else{
				print_r($query->result());
			}
			// $this->load->view($data['Web_TempName'].'/'.$page,$data);	
		}
	}
	
	// 點擊頁面
	public function RecommendData($domain = NULL)
	{
		$search_time = '2019-06-01 00:00:00';
		$Stime = date('Y-m-d 00:00:00', strtotime('-30 days'));
		$Etime = date('Y-m-d 00:00:00');
		$Search_Time_Interval_Sql = " AND UpdateTime > '".$Stime."' AND  UpdateTime < '".$Etime."' ";
    	$Language = [ 'zh-Hant' , 'zh-Hans' ];
		$PageName = array();
		$sql = null;

		switch($domain){
			case 'luxurywatcher':
    			$sql = "SELECT NowUrl,LinkUrl,COUNT(ID) AS LinkCount FROM `data_statistics` 
    			WHERE NowUrl LIKE '%" . $domain ."%' AND UpdateTime > '" . $search_time . "' 
    			AND LinkName != 'Load'
    			AND (
    				LinkUrl Like '%Catalog/Jewelry%'
    				OR LinkUrl Like '%Catalog/Watch%'
    				OR LinkUrl Like '%Catalog/Motor%'
    				OR LinkUrl Like '%Catalog/Living%'
    				OR LinkUrl Like '%Catalog/Fashion%'
    				OR LinkUrl Like '%Catalog/Lifestyle%'
    			)".$Search_Time_Interval_Sql."
    			GROUP BY LinkUrl,NowUrl ORDER BY LinkCount DESC";
    			$PageName = array('index', 'Jewelry', 'Watch', 'Motor', 'Living', 'Fashion', 'Lifestyle');
			break;
			case 'world-wrist-watch':
    			$sql = "SELECT NowUrl,LinkUrl,COUNT(ID) AS LinkCount FROM `data_statistics` 
    			WHERE NowUrl LIKE '%" . $domain ."%'  
    			AND LinkName != 'Load'
    			AND (
    				LinkUrl Like '%Catalog/News%'
    				OR LinkUrl Like '%Catalog/Topic%'
    				OR LinkUrl Like '%Catalog/Review%'
    				OR LinkUrl Like '%Catalog/Watch%'
    				OR LinkUrl Like '%Catalog/Knowledge%'
    				OR LinkUrl Like '%Catalog/Dictionary%'
    			)".$Search_Time_Interval_Sql."
    			GROUP BY LinkUrl,NowUrl ORDER BY LinkCount DESC";
    			$PageName = array('index', 'News', 'Topic', 'Review', 'Watch', 'Knowledge', 'Dictionary');
			break;
		}
	
		if(!empty($sql)){

            // 查詢所有頁面結果
			$query = $this->db->query($sql);
			
			$Url = Array();
			foreach($query->result() as $key => $row){
				if(strlen($row->NowUrl) > 0){
					$d = explode('/',rawurldecode(rawurldecode($row->NowUrl)));
					
					// 自動新增既有語系
					if(!in_array($d[1],$Language)) $Language[] = $d[1];

					$page = isset($d[2]) ? $d[2] : 'index';
					$type = isset($d[3]) ? $d[3] : 'index';

					$luArray = explode('://',rawurldecode(rawurldecode($row->LinkUrl)));
					$lu = explode('/', (count($luArray) > 1 ? $luArray[1] : $luArray[0]));
					$lu_type =  isset($lu[3]) ? $lu[3] : 'index';
					if(in_array($type,$PageName)){
						$Url[$d[1]][$type][$lu_type] = isset($Url[$d[1]][$type][$lu_type] ) ? intval($Url[$d[1]][$type][$lu_type]) + intval($row->LinkCount) : $row->LinkCount;
					}
				}
			}

	        
	        foreach($Language as $key => $lg){
				foreach($PageName as $key => $pg){
					if(in_array($pg,$PageName)){
						$TagArray = array();
						$tag_pageSql = $pg == 'index' ? " NowUrl LIKE '%" . $lg . "'" : " NowUrl LIKE '%" . $pg . "%' ";
						$tag_sql = "SELECT LinkName as tag,count(ID) as LinkCount FROM `data_statistics`
						            WHERE NowUrl LIKE '%" . $domain ."%'
						            AND " . $tag_pageSql ." 
						            AND LinkUrl LIKE '%earch/tag%' 
						            AND NowUrl LIKE '%" . $lg ."%' 
						            AND UpdateTime > '" . $search_time . "' 
        							".$Search_Time_Interval_Sql."
        							GROUP by LinkName ORDER BY LinkCount DESC";
						$tag_query = $this->db->query($tag_sql);
						foreach($tag_query->result() as $key => $row){
							$TagArray[$key]['Name'] = trim(strip_tags($row->tag));
							$TagArray[$key]['Count'] = $row->LinkCount;
						}
						$Url[$lg][$pg]['tag'] = $TagArray;
					}
				}
			}
				
			// 查詢 Domain ID 
			$DomainSQL = "SELECT Domain,ID FROM web_domain WHERE Domain = '". $domain .".com'" ;
			$DomainQuery = $this->db->query($DomainSQL);
			if(isset($DomainQuery->result()[0]->Domain)){
				// 存入 API 資料
				$data = array(
					// Domain ID
					'web_domain_ID' => $DomainQuery->result()[0]->ID
					// 建立時間
					, 'UpdateTime' => date('Y-m-d H:i:s')
					// API ID
					, 'API_ID' => 1
					// API 資料查詢 開始時間
					, 'API_Stime' => $Stime
					// API 資料查詢 結束時間
					, 'API_Etime' => $Etime
					// API 資料查詢 
					, 'API_Data' => json_encode( $Url, JSON_UNESCAPED_UNICODE )
				);
				// 寫入 SQL 語法組合 & 跳脫
				$InsertSQL = $this->db->insert_string('api_data', $data);
				// 執行 SQL / 寫入資料
				$this->db->query($InsertSQL);
			}
		}
	}
	
	// 寫入
	public function AddUser(){
		$data = array(
			// 更新時間
			'UpdateTime' => date('Y-m-d H:i:s')
			// 網頁開始時間
			, 'Domain' => rawurldecode(rawurldecode($this->input->get('domain')))
			// 來源網址
			, 'Stime' => '2019-04-02 00:00:00'
			// 來源IP
			, 'Etime' => '2019-04-03 00:00:00'
		);

		// 檢查是否填寫
		if(strlen($data['Domain']) > 0){
			
			$sql = "SELECT Domain FROM web_domain WHERE Domain = '". $data['Domain'] ."'" ;
			$query = $this->db->query($sql);

			
			if(isset($query->result()[0]->Domain)){
				echo '已存在';
			}else{
				// 寫入 SQL 語法組合 & 跳脫
				$sql = $this->db->insert_string('web_domain', $data);
				// 執行 SQL / 寫入資料
				$this->db->query($sql);
			}
		}
	}

	// 加密
	public function EncryptionEncode()
	{
		$output = false;
		$encrypt_method = "AES-256-CBC";
		$secret_key = $this->config->item('encryption_key');
		$domain = 'luxurywatcher.com';
		// 現在時間 / Domain 網址
		$secret_iv = json_encode( array('Key' => $secret_key, 'Domain' => $domain), JSON_UNESCAPED_UNICODE );

		// hash TTkydDVjRERjQXJUdjlOWTlURUNxUGxSWWZLdmV0cmdXL1FRZm5xdzJvOD0=
		$key = hash('sha256', $secret_key);
		// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
		$iv = substr(hash('sha256', $secret_iv), 0, 16);

		$output = base64_encode(openssl_encrypt($secret_iv, $encrypt_method, $key, 0, $iv));
		
		echo $output;exit;
	}
	// 解密
	public function EncryptionDecode()
	{
		$output = false;
		$encrypt_method = "AES-256-CBC";
		$secret_key = $this->config->item('encryption_key');
		$domain = 'luxurywatcher.com';
		// 現在時間 / Domain 網址
		$secret_iv = json_encode( array('Key' => $secret_key, 'Domain' => $domain), JSON_UNESCAPED_UNICODE );

		$string = $this->input->get('str');

		// hash TTkydDVjRERjQXJUdjlOWTlURUNxUGxSWWZLdmV0cmdXL1FRZm5xdzJvOD0=
		$key = hash('sha256', $secret_key);
		// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
		$iv = substr(hash('sha256', $secret_iv), 0, 16);

		$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0,$iv);

		echo json_encode($output);
		//$this->load->view('encryption');
	}
	// 流量來源網站
	public function SearchSourceUrl()
	{
		$domainID = $this->input->get('key');


		$sql = "SELECT SourceUrl,COUNT(ID) AS SourceCount FROM `data_statistics` WHERE NowUrl LIKE '%luxurywatcher.com%' AND UpdateTime > '2019-03-29 00:00:00' GROUP BY SourceUrl ORDER BY SourceCount DESC";
		
		$query = $this->db->query($sql);
		
		$Url = Array();
		foreach($query->result() as $key => $row){
			if(strlen($row->SourceUrl) > 0){
				$d = explode('://',rawurldecode(rawurldecode($row->SourceUrl)));
				if(count($d) > 1){
					$domain = explode('/',(explode('://',rawurldecode(rawurldecode($row->SourceUrl)))[1]))[0];
					$Url[$domain] = isset($Url[$domain]) ? intval($Url[$domain]) + intval($row->SourceCount) : $row->SourceCount;
				}
			}
		}
		$data['Url'] = $Url;
		$this->load->view('SearchSourceUrl',$data);
	}
	// api 資料
	public function APIDATA()
	{
		$domainID = $this->input->get('key');


		$sql = "SELECT API_Data FROM `api_data` WHERE web_domain_ID = 2 ORDER BY ID DESC LIMIT 1";
		
		$query = $this->db->query($sql);
		
		$API_DATA = json_decode($query->result()[0]->API_Data);
		// print_r($API_DATA);
		$NowAPIData = [];
		foreach($API_DATA as $lgName => $lgData){
			echo '語系 :'.$lgName.'<br>';
			echo '<br>';
			foreach($lgData as $pageName => $pageData){
				foreach($pageData as $clickPage => $clickNum)
					if( $clickPage  != 'tag') $NowAPIData[$lgName][$pageName][$clickPage] = $clickNum;
					else{
						foreach($clickNum as $tagkey => $tag){
							$NowAPIData[$lgName][$pageName][$clickPage][$tagkey]['Name'] = $tag->Name;
							$NowAPIData[$lgName][$pageName][$clickPage][$tagkey]['Count'] = $tag->Count;
							if($tagkey >= 30) break;
						}
					} 

			}
		}
		echo json_encode($NowAPIData);
		// $str = '{"zh-Hant":{"index":{"Watch":89,"Living":55,"Motor-Yacht":44,"Jewelry":42,"Lifestyle":30,"Fashion":25,"tag":[{"Name":"Porsche","Count":"1"},{"Name":"SUV","Count":"1"},{"Name":"SOGO\u5fa9\u8208\u9928","Count":"1"},{"Name":"\u52de\u529b\u58eb 116900","Count":"1"},{"Name":"\u52de\u529b\u58eb 2019\u65b0\u6b3e","Count":"1"},{"Name":"\u4fdd\u6642\u6377","Count":"1"},{"Name":"\u5927\u4e09\u91dd","Count":"1"},{"Name":"488 Pista Spider","Count":"1"},{"Name":"SUMMIT\u667a\u80fd\u8155\u9336","Count":"1"},{"Name":"\u52de\u529b\u58eb 2019\u65b0\u6b3e\u552e\u50f9","Count":"1"},{"Name":"\u4f73\u58eb\u5f97","Count":"1"},{"Name":"\u6cd5\u62c9\u5229\u655e\u7bf7\u8eca","Count":"1"}]},"Living":{"Living":141,"Lifestyle":24,"Fashion":24,"Motor-Yacht":"15","Watch":13,"Jewelry":3,"tag":[{"Name":"Antonio Citterio","Count":"1"}]},"Watch":{"Watch":150,"Motor-Yacht":26,"Fashion":18,"Living":14,"Jewelry":11,"Lifestyle":"5","tag":[{"Name":"\u2192","Count":"49"},{"Name":"2","Count":"39"},{"Name":"\u52de\u529b\u58eb","Count":"26"},{"Name":"\u52de\u529b\u58eb 2019\u65b0\u6b3e\u552e\u50f9","Count":"26"},{"Name":"\u611b\u99ac\u4ed5","Count":"26"},{"Name":"HERMES","Count":"20"},{"Name":"\u52de\u529b\u58eb 2019\u65b0\u6b3e","Count":"19"},{"Name":"\u51f1\u8389\u5305","Count":"19"},{"Name":"3","Count":"17"},{"Name":"\u67cf\u91d1\u5305","Count":"15"},{"Name":"ROLEX","Count":"15"},{"Name":"Sea-Dweller","Count":"11"},{"Name":"GMT-Master II","Count":"10"},{"Name":"4","Count":"10"},{"Name":"5","Count":"9"},{"Name":"\u7537\u7528\u5305\u5305\u63a8\u85a6","Count":"9"},{"Name":"304\u4e0d\u93fd\u92fc","Count":"9"},{"Name":"430\u4e0d\u93fd\u92fc","Count":"8"},{"Name":"Day-Date 36","Count":"8"},{"Name":"6","Count":"8"},{"Name":"\u5361\u5730\u4e9e","Count":"7"},{"Name":"\u7da0\u6c34\u9b3c","Count":"7"},{"Name":"\u9999\u5948\u5152","Count":"7"},{"Name":"316\u4e0d\u93fd\u92fc","Count":"6"},{"Name":"\u5bf6\u683c\u9e97","Count":"6"},{"Name":"DELVAUX","Count":"6"},{"Name":"Explorer II","Count":"6"},{"Name":"\u4e09\u74b0\u6212","Count":"6"},{"Name":"Yacht-Master 42","Count":"6"},{"Name":"Chanel 2.55","Count":"6"},{"Name":"\u7537\u58eb\u5305\u5305","Count":"6"}]},"Jewelry":{"Watch":"31","Jewelry":64,"Fashion":11,"Motor-Yacht":"3","Living":2,"Lifestyle":"1","tag":[{"Name":"\u5eab\u5229\u5357\u947d\u77f3","Count":"1"},{"Name":"Pt900","Count":"1"},{"Name":"\u9251\u91d1","Count":"1"},{"Name":"\u6212\u6307","Count":"1"}]},"Fashion":{"Fashion":87,"Lifestyle":28,"Living":13,"Motor-Yacht":8,"Watch":"6","Jewelry":6,"tag":[{"Name":"\u611b\u99ac\u4ed5","Count":"1"},{"Name":"\u65e5\u5e38\u7a7f\u642d","Count":"1"},{"Name":"\u897f\u88dd","Count":"1"},{"Name":"\u8d85\u8f15\u91cf\u904b\u52d5\u978b","Count":"1"},{"Name":"2019\u6625\u590f\u65b0\u54c1","Count":"1"},{"Name":"\u76ae\u9769","Count":"1"}]},"Lifestyle":{"Fashion":27,"Lifestyle":60,"Living":"13","Motor-Yacht":12,"Watch":4,"Jewelry":3,"tag":[{"Name":"\u7f8e\u98df\u63a8\u85a6","Count":"1"},{"Name":"\u4e9e\u6d32\u6771\u65b9\u5feb\u8eca","Count":"1"},{"Name":"\u6642\u5c1a\u9152\u5427","Count":"1"},{"Name":"LALIQUE","Count":"1"},{"Name":"Jean-Michel Gathy","Count":"1"}]},"Motor-Yacht":{"Motor-Yacht":90,"Watch":24,"Living":26,"Fashion":"10","Lifestyle":9,"Jewelry":"3","tag":[{"Name":"\u52de\u65af\u840a\u65af","Count":"1"},{"Name":"\u6cd5\u62c9\u5229","Count":"1"},{"Name":"\u963f\u806f\u914b","Count":"1"}]}},"zh-Hans":{"index":{"Watch":"14","Fashion":"10","Living":8,"Lifestyle":"6","Jewelry":6,"Motor-Yacht":3,"tag":[{"Name":"\u9640\u98de\u8f6e","Count":"1"},{"Name":"\u6c34\u9b3c","Count":"1"}]},"Living":{"Living":52,"Lifestyle":"2","tag":[{"Name":"Gaggenau","Count":"1"},{"Name":"\u53a8\u623f","Count":"1"}]},"Watch":{"Watch":64,"Jewelry":"2","Motor-Yacht":"2","Fashion":"2","tag":[{"Name":"2","Count":"13"},{"Name":"3","Count":"11"},{"Name":"\u540d\u4eba\u8c6a\u5b85","Count":"4"},{"Name":"\u8c6a\u5b85","Count":"3"},{"Name":"4","Count":"2"},{"Name":"RIEDEL\u9152\u676f\u63a8\u8350","Count":"2"},{"Name":"\u65e5\u672c\u6599\u7406","Count":"2"},{"Name":"Wedgwood","Count":"2"},{"Name":"\u7ecf\u5178\u5355\u6905","Count":"2"},{"Name":"\u7eff\u6c34\u9b3c","Count":"2"},{"Name":"a.testoni","Count":"2"},{"Name":"ROLEX","Count":"2"},{"Name":"2019","Count":"2"},{"Name":"A. LANGE & S\u00d6HNE","Count":"2"},{"Name":"\u2192","Count":"2"},{"Name":"\u7231\u9a6c\u4ed5","Count":"2"},{"Name":"IWC","Count":"2"},{"Name":"\u9152\u676f","Count":"1"},{"Name":"\u8461\u8404\u9152\u77e5\u8bc6","Count":"1"},{"Name":"\u5c45\u5bb6","Count":"1"},{"Name":"\u6700\u597d\u5403\u7684\u725b\u8089","Count":"1"},{"Name":"2.55","Count":"1"},{"Name":"\u51ef\u8389\u5305","Count":"1"},{"Name":"\u7537\u6027\u5305\u5305","Count":"1"},{"Name":"\u52b3\u529b\u58eb 2019\u65b0\u6b3e\u552e\u4ef7","Count":"1"},{"Name":"\u78b3\u7ea4\u7ef4","Count":"1"},{"Name":"SCHRAMM","Count":"1"},{"Name":"\u4e1d\u5dfe","Count":"1"},{"Name":"\u52b3\u529b\u58eb126300","Count":"1"},{"Name":"\u7956\u6bcd\u7eff","Count":"1"},{"Name":"EXP-6","Count":"1"}]},"Jewelry":{"Jewelry":16,"Watch":"1","Fashion":2,"tag":[{"Name":"MIKIMOTO","Count":"1"},{"Name":"\u7c89\u7ea2\u94bb","Count":"1"}]},"Lifestyle":{"Fashion":"4","Living":"2","Lifestyle":22,"Jewelry":"2","tag":[{"Name":"LALIQUE","Count":"1"}]},"Motor-Yacht":{"Motor-Yacht":8,"Living":"3","Lifestyle":"2"},"Fashion":{"Fashion":8,"Lifestyle":3,"Jewelry":"1","Watch":"1","Living":"1","tag":[{"Name":"\u9152\u795e\u5305","Count":"1"},{"Name":"Chanel Boy","Count":"1"},{"Name":"S.T. Dupont","Count":"1"},{"Name":"a.testoni","Count":"1"},{"Name":"\u7231\u9a6c\u4ed5","Count":"1"}]}}}';
		// print_r(json_decode($str));
		
	}
	public function GaApi(){
		header('Access-Control-Allow-Headers: Content-Type');
		header('Access-Control-Allow-Origin:*');
		header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
		header('Content-Type: application/json; charset=utf-8');

		$this->load->library('curl');

		$GAAPI = 'https://www.googleapis.com/analytics/v3/data/ga?ids=ga%3A186962147&start-date=30daysAgo&end-date=yesterday&metrics=ga%3Apageviews&dimensions=ga%3AreferralPath&access_token=ya29.GlsfBw6fyOe5i_8nrFJLGkSmtL7NXMY0CFZW04VrF1dwIQDiNlritAQrNVCXONTyTrXnFoQojq84cl7LilxI4gOmdNu2g08l936FHllTSU7gCVyoa31Wz7LoCGd6';
		
		$result = $this->curl->simple_get($GAAPI);
		var_dump($result);
		echo 'GaApi<br>';

		print_($result);
	}
	public function WPV(){
    	header('Access-Control-Allow-Headers: Content-Type');
		header('Access-Control-Allow-Origin: https://www.world-wrist-watch.com');
		header('Access-Control-Allow-Methods: GET, POST');
		header('Content-Type: application/json; charset=utf-8');
		$Stime = date('Y-m-d', strtotime('-31 days'));
		$Etime = date('Y-m-d', strtotime('-1 days'));
	    
	    $sql ="SELECT 
                	SUBSTRING_INDEX( URL , '/' , 1) AS Brand 
                    , SUBSTRING_INDEX( SUBSTRING_INDEX( URL , '/' , 2)  , '/' , -1) AS Series 
                    , SUBSTRING_INDEX(  SUBSTRING_INDEX( SUBSTRING_INDEX( URL , '/' , 3)  , '/' , -1)  , '?' , 1) AS Name 
                    , WatchCount
                FROM (
                    SELECT SUBSTRING_INDEX( LOWER(NowUrl) , '/watch/' , -1) AS URL
                    , COUNT(*) AS WatchCount
                    FROM `data_statistics` 
                    WHERE web_domain_id = 2 AND index_date >= '" . $Stime . "' AND index_date < '" . $Etime . "' AND LOWER(NowUrl) LIKE '%/watch/%' 
                    GROUP BY NowUrl ORDER BY COUNT(*) DESC
                ) AS watch 
                WHERE SUBSTRING_INDEX( URL , '/' , 1) != '' 
                AND SUBSTRING_INDEX( URL , '/' , 1) != SUBSTRING_INDEX( SUBSTRING_INDEX( URL , '/' , 2)  , '/' , -1)";
                
    	$query = $this->db->query($sql); 
    	
    	$data = $query->result_array();
    // 	foreach($data as $key => $item){
    	    
    	    
    	    
    // 	}
    	
    // 	print_r($data);
    // 	echo $query->num_rows();
	}
}
