<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Curl Model
class CI_Curl
{
	public function __construct()
	{
	}
	
	//取遠端資料 $url 為網址, $post_array為POST的值(沒有就不用代), 註:要使用Array
	public function get_api($url = '', $post_array = array(), $type='json')
	{
		set_time_limit(60); //設定Timeout 60秒
		
		$html = '';
		$url_query = explode('?', $url);
		isset($url_query[1]) OR ($url_query[1]='');

		try
		{
			if(strlen($url) == 0)
				return '';
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_HEADER, 0);
			
			$headers = array();
			switch($type)
			{
				case 'json': $headers[] = 'Content-Type: application/json; charset=utf-8'; break;
				case 'text': $headers[] = 'Content-Type: text/plain; charset=utf-8'; break;
				case 'html': $headers[] = 'Content-type: text/html; charset=utf-8'; break;
				default: $headers[] = 'Content-type: application/x-www-form-urlencoded; charset=utf-8'; break;
			}
			
			if(count($post_array) > 0)
			{
				switch($type)
				{
					case 'json':
						$headers[] = 'Content-Length:' . strlen( json_encode( $post_array, JSON_UNESCAPED_UNICODE ) );
						curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode( $post_array, JSON_UNESCAPED_UNICODE ) );
					break;
					
					default:
						$headers[] = 'Content-Length:' . strlen( http_build_query( $post_array ) );
						curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query( $post_array ));
					break;
				}
				
				curl_setopt($ch, CURLOPT_POST, TRUE);
			}
			
			
			if(count($headers) > 0)
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
			$result = curl_exec($ch);
			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			
			if(($httpCode == 0) || ($httpCode == 404))
			{
				ACTION_LOG( 'ERROR', "呼叫網址:{$url}失敗", __FILE__, __LINE__, $url_query[0], $url_query[1], http_build_query( $post_array ) );
				die('呼叫.Net API失敗');
			}
			
			curl_close($ch);
		}
		catch(Exception $e)
		{
			ACTION_LOG( 'ERROR', "呼叫網址:{$url}失敗 {$e}", __FILE__, __LINE__, $url_query[0], $url_query[1], http_build_query( $post_array ) );
			die('呼叫.Net API失敗');
		}

		return $result;
	}
	
		
}
?>