<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class API extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Api_model');
		$this->load->database();
		$this->load->helper('url');
		// 設定時間 Asia/Taipei
		ini_set('date.timezone','Asia/Taipei');
		//如果是本機，或和泰聯網IP，才開啟跨網域存取
		// if( in_array( strval($this->input->ip_address()), IGNORE_ORIGIN_ADDRESS ) )
		// {
			header('Access-Control-Allow-Headers: Content-Type');
			header('Access-Control-Allow-Origin:*');
			header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
		// }
		// else
		// {
		// 	header('Access-Control-Allow-Origin: '. site_url());
		// }
		header('Content-Type: application/json; charset=utf-8');
	}

	public function test()
	{
        // $WebDomain = $this->Api_model->WebDomain('luxury');
        // print_r($WebDomain);
        	exit;
	}
	public function index()
	{
		// 更新時間
		$data['UpdateTime'] = date('Y-m-d H:i:s');
		// 網頁開始時間
		$data['Stime'] = date('Y-m-d H:i:s',$this->input->get('stime'));
		// 來源網址
		$data['SourceUrl'] = rawurldecode($this->input->get('sourceurl'));
		// 來源IP
		$data['SourceIp'] = $this->input->ip_address();
		// 目前網址
		$data['NowUrl'] = rawurldecode($this->input->get('nowurl'));
		// 網頁大小
		$data['WebSize'] = $this->input->get('web_width') . ',' . $this->input->get('web_height');
		// 點擊位置
		$data['Location'] = $this->input->get('location');
		// 點擊連結
		$data['LinkUrl'] = rawurldecode($this->input->get('link'));
		// 點擊名稱
		$data['linkName'] = rawurldecode($this->input->get('name'));
		// 點擊類別 Menu,Tag,link,banner,button
		$data['linkType'] = rawurldecode($this->input->get('type'));
		
		$NowUrlArray = explode('/',$data['NowUrl']);
		
		$data['web_domain_id'] = 0;
		if(preg_match("/www.luxurywatcher.com/i", strtolower($data['NowUrl'])))$data['web_domain_id'] = 1;
		if(preg_match("/www.world-wrist-watch.com/i", strtolower($data['NowUrl'])))$data['web_domain_id'] = 2;
// 		$data['web_domain_id'] = ? '2' : preg_match("/www.luxurywatcher.com/i", strtolower($data['NowUrl']) ) ? '1' : NULL;
		$data['index_date'] = date("Y-m-d" , strtotime($data['UpdateTime']));
		$data['index_year'] = date("Y" , strtotime($data['UpdateTime']));
	    $data['index_month'] = date("m" , strtotime($data['UpdateTime']));
	    
	    
		$sql = 'INSERT INTO data_statistics (
		                    `web_domain_id`
		                    ,`index_date`
		                    ,`index_year`
		                    ,`index_month`
							,`UpdateTime`
							,`Stime`
							,`SourceUrl`
							,`SourceIp`
							,`NowUrl`
							,`WebSize`
							,`Location`
							,`LinkUrl`
							,`LinkName`
							,`LinkType`
							) VALUES (
							' . $data['web_domain_id'] . '
							,\'' . $data['index_date'] . '\'
							,\'' . $data['index_year'] . '\'
							,\'' . $data['index_month'] . '\'
							,\'' . $data['UpdateTime'] . '\'
							,\'' . $data['Stime']  . '\'
							,\'' . $data['SourceUrl']  . '\'
							,\'' . $data['SourceIp'] . '\'
							,\'' . $data['NowUrl'] . '\'
							,\'' . $data['WebSize'] . '\'
							,\'' . $data['Location'] . '\'
							,\'' . $data['LinkUrl'] . '\'
							,\'' . $data['linkName'] . '\'
							,\'' . $data['linkType'] . '\'
						)';

		$this->load->database();
		if($this->db->query($sql)){
			// if(!empty($data['NowUrl'])){
			// 	if (preg_match("/". strtotime('www.world-wrist-watch.com/zh-Hant/Product') ."/i", $data['NowUrl'])) {
			// 		$urlarray = explode('/',$data['NowUrl']);
			// 		$urlarray = explode('?',end($urlarray));
			// 		$WatchID = $urlarray[0];
					
			// 		$sql = 'INSERT INTO PageViewCount (
			// 				`update_date`
			// 				,`source_table`
			// 				,`source_id`
			// 				,`source_count`
			// 				) VALUES (
			// 				\'' . $data['UpdateTime'] . '\'
			// 				,\'watch\'
			// 				,\'' . $WatchID . '\'
			// 				, 1
			// 			)';
			// 		$this->db->query($sql);
			// 	}
			// }
			// echo json_encode( 'true', JSON_UNESCAPED_UNICODE );
		}
		$this->db->close();
	exit;
		
	}
	
	// 世界腕表 > 文章 PV ID : 用於抓取近期熱門文章
	public function WAHot($day = 30 , $LIMIT = 10 , $Article = NULL){

        $SreachDete = date("Y-m-d H:i:s",strtotime("-" . $day . " day"));
        $Article_Id = empty($Article) ? NULL : ' AND source_id = ' . $Article;
	    $Article_Array = empty($this->input->get('a')) ? NULL : ' AND source_id in(' . $this->input->get('a') . ')';
	    $sql = 'SELECT source_id , count(id) as CID FROM `PageViewCount` 
	            WHERE update_date >= \'' . $SreachDete . '\' ' .' AND source_table = \'article\' '. $Article_Id .  $Article_Array .' GROUP BY source_id ORDER BY CID DESC LIMIT ' . $LIMIT;

		$result = $this->db->query($sql);
		$data = $result->result_array();

        if(!empty($Article) && empty($Article_Array)) echo $data[0]['CID'].'#';
        else echo json_encode( $data, JSON_UNESCAPED_UNICODE );
        	exit;
	   
	}
	
	

	// 世界腕表 > 腕表 Hot ID : 用於抓取近期熱門表款
	public function WPVHot(){

		$jsonString = json_decode($this->input->raw_input_stream, TRUE);
		
		$data = FALSE;
		// 限制存取來源
		if( (!empty($jsonString['source_url']) && preg_match("/". strtolower('www.world-wrist-watch.com') ."/i", $jsonString['source_url'])) || $jsonString['source_url']['u'] == 'sean') {
			$day = rawurldecode($jsonString['day']);
			$day = preg_match("/\d$/", $day) ? $day : 1;
			$Etime = date('Y-m-d H:i:s');
			$Stime = date("Y-m-d H:i:s",strtotime("-" . $day . " day",strtotime($Etime)));
			$sql = 'SELECT source_id as source_id , count(source_count) as source_count FROM `PageViewCount` 
					WHERE update_date > \'' . $Stime . '\' AND update_date <= \'' . $Etime . '\' 
					AND source_table = \'watch\' 
					GROUP BY source_id ORDER BY source_count DESC LIMIT 100';

			$this->load->database();
			$result = $this->db->query($sql);
			$data = $result->result();
			$this->db->close();		
		}

		echo json_encode( $data, JSON_UNESCAPED_UNICODE );
			exit;
	}

	// 世界腕表 > 腕表 PV Count : 用於紀錄熱門表款
	public function WPVCount(){
		
		$data = FALSE;
		$source_url_strtotime = strtolower( strval($_SERVER["HTTP_REFERER"]) );
		var_dump();
		$this->load->database();
		if(!empty($_SERVER["HTTP_REFERER"])){
			if ( strpos($source_url_strtotime,strtolower('www.world-wrist-watch.com/zh-Hant/Product')) !== FALSE ) {
				$Source =[
					'date' => date('Y-m-d H:i:s'),
					'url' => $_SERVER["HTTP_REFERER"],
					'table' => 'watch',
					'id' => rawurldecode($this->input->get('wid')),
					'count' => 1,
				];
				$sql = 'INSERT INTO PageViewCount (
						`update_date`
						,`source_url`
						,`source_table`
						,`source_id`
						,`source_count`
						) VALUES (
						\'' . $Source['date'] . '\'
						,\'' . $Source['url'] . '\'
						,\'' . $Source['table'] . '\'
						,\'' . $Source['id'] . '\'
						,\'' . $Source['count'] . '\'
					)';
				$this->db->query($sql);
				$data = TRUE;
			}
		}
		$this->db->close();
		echo json_encode( $data, JSON_UNESCAPED_UNICODE );
			exit;
	}

	// Search PV Count API
	public function PVCount(){

		$data = FALSE;
		$source_url_strtotime = strtolower( strval($_SERVER["HTTP_REFERER"]) );

		if(!empty($_SERVER["HTTP_REFERER"])){
			if ( strpos($source_url_strtotime,strtolower('www.world-wrist-watch.com/zh-Hant/')) !== FALSE ) {

				$source_type = NULL;

				if( strpos($source_url_strtotime ,'/search/tag') ) $source_type = 'tag';
				if( strpos($source_url_strtotime ,'/search/keyword') ) $source_type = 'keyword';
				if( strpos($source_url_strtotime ,'/search/category') ) $source_type = 'category';
				if( strpos($source_url_strtotime ,'/product') ) $source_type = 'watch';
				if( strpos($source_url_strtotime ,'/article/') ) $source_type = 'article';
				
				if(!empty($source_type)){
					$this->load->database();
					$Source =[
						'date' => date('Y-m-d H:i:s'),
						'url' => $_SERVER["HTTP_REFERER"],
						'table' => $source_type,
						'id' => strval(rawurldecode($this->input->get('s'))),
						'count' => 1,
					];
					$sql = 'INSERT INTO PageViewCount (
							`update_date`
							,`source_url`
							,`source_table`
							,`source_id`
							,`source_count`
							) VALUES (
							\'' . $Source['date'] . '\'
							,\'' . $Source['url'] . '\'
							,\'' . $Source['table'] . '\'
							,\'' . $Source['id'] . '\'
							,\'' . $Source['count'] . '\'
						)';
					$this->db->query($sql);
					$this->db->close();
					$data = TRUE;
				}
			}
		}
	
		echo json_encode( $data, JSON_UNESCAPED_UNICODE );
			exit;
		
	}
	// 熱門文章 - 資料查詢API
	public function HotArticleTopSearch($domain = NULL){
	    $data = [];
	    
	    // 查詢 Domain
		$WebDomain = $this->Api_model->WebDomain($domain);
		
        if(!empty($WebDomain)){
            $sql = 'SELECT * FROM `api_data` WHERE web_domain_ID = ' . $WebDomain['ID'] . ' AND API_ID = 4  ORDER BY `ID` DESC LIMIT 1';
            $query = $this->db->query($sql);
            foreach($query->result_array() as $key => $row){
                $data = json_decode($row['API_Data']);
            }
        }
	    echo json_encode( $data, JSON_UNESCAPED_UNICODE );
	    	exit;

	}
	
	// 熱門文章 - 資料寫入API
	public function HotArticleTopInsert($domain = NULL){
	    
	    $data = [];

        // 查詢 Domain
		$WebDomain = $this->Api_model->WebDomain($domain);

        if(!empty($WebDomain)){

    	    // 開始時間
    	    $Stime = date('Y-m-d H:i:s' , strtotime('-1 days'));
    	    // 結束時間
    	    $Etime = date('Y-m-d H:i:s');
	    
    	    $value = 100;
    	    $sql = 'SELECT NowUrl , count(NowUrl) as NowUrlCount FROM `data_statistics` WHERE UpdateTime > \'' . $Stime . '\' AND NowUrl LIKE \'%rticle/%\' AND NowUrl LIKE \'%' . $WebDomain['Domain'] . '%\' GROUP BY NowUrl ORDER by NowUrlCount DESC limit '. $value;
    
    		
    		$query = $this->db->query($sql);
    		
    		
    		$pvc = 0;
    		foreach($query->result_array() as $key => $row){
    		    $a = explode( '/' , $row['NowUrl']);
    		    
    		    $ArticleID = explode('?' , end($a) )[0] ;
    			$data[] = [
    			    'ID' => $ArticleID,
    			    'PV' => $row['NowUrlCount']
    			];
    			$pvc += (int)$row['NowUrlCount'];
    		}
    		
			// 備份紀錄 存入 API 資料
			$insert_sql = array(
				// Domain ID
				'web_domain_ID' => $WebDomain['ID']
				// 建立時間
				, 'UpdateTime' => date('Y-m-d H:i:s')
				// API ID
				, 'API_ID' => 4
				// API 資料查詢 開始時間
				, 'API_Stime' => $Stime
				// API 資料查詢 結束時間
				, 'API_Etime' => $Etime
				// API 資料查詢 
				, 'API_Data' => json_encode( $data, JSON_UNESCAPED_UNICODE )
			);
			// 寫入 SQL 語法組合 & 跳脫
			$InsertSQL = $this->db->insert_string('api_data', $insert_sql);
			// 執行 SQL / 寫入資料
			$this->db->query($InsertSQL);
        } 

	    echo json_encode( $data, JSON_UNESCAPED_UNICODE );
	    	exit;

	}
	// 文章推薦 - 資料查詢API
	public function RecommendDataSearch($domain = NULL){
	    $data = [];
	    
	    // 查詢 Domain
		$WebDomain = $this->Api_model->WebDomain($domain);
		
        if(!empty($WebDomain)){
            $sql = 'SELECT * FROM `api_data` WHERE web_domain_ID = ' . $WebDomain['ID'] . ' AND API_ID = 3  ORDER BY `ID` DESC LIMIT 1';
            $query = $this->db->query($sql);
            foreach($query->result_array() as $key => $row){
                $data = json_decode($row['API_Data']);
            }
        }
	    echo json_encode( $data, JSON_UNESCAPED_UNICODE );
	    	exit;

	}
	
	// 文章推薦 - 資料寫入排程
	public function RecommendDataInsert($domain = NULL){
	    $search_time = '2019-06-01 00:00:00';
		$Stime = date('Y-m-d H:i:s', strtotime('-30 days'));
		$Etime = date('Y-m-d H:i:s');
		$Search_Time_Interval_Sql = " UpdateTime > '".$Stime."' AND  UpdateTime < '".$Etime."' ";
    	$Language = [ 'zh-Hant' , 'zh-Hans' ];
		$PageName = array();
		$sql = null;
        $data = ['API_Data' =>  [] ];
		
        
        // 查詢 Domain
		$WebDomain = $this->Api_model->WebDomain($domain);
	    if($this->input->get('aaa') === 'aaa'){
    	    $WebDomain['Domain'] = 'world-wrist-watch.com';
		}
		if(!empty($WebDomain)){
		    
		    switch($WebDomain['Domain']){
    			case 'luxurywatcher.com':
        			$sql = "SELECT NowUrl,LinkUrl,COUNT(ID) AS LinkCount FROM `data_statistics` 
        			WHERE 
        			".$Search_Time_Interval_Sql." AND LinkName != 'Load' AND UpdateTime > '" . $search_time . "' 
        			AND NowUrl LIKE '%" . $WebDomain['Domain'] ."%' 
        			AND (
        				LinkUrl Like '%Catalog/Jewelry%'
        				OR LinkUrl Like '%Catalog/Watch%'
        				OR LinkUrl Like '%Catalog/Motor%'
        				OR LinkUrl Like '%Catalog/Living%'
        				OR LinkUrl Like '%Catalog/Fashion%'
        				OR LinkUrl Like '%Catalog/Lifestyle%'
        			)
        			GROUP BY LinkUrl,NowUrl ORDER BY LinkCount DESC";
        			$PageName = array('index', 'Jewelry', 'Watch', 'Motor', 'Living', 'Fashion', 'Lifestyle');
    			break;
    			case 'world-wrist-watch.com':
        			$sql = "SELECT NowUrl,LinkUrl,COUNT(ID) AS LinkCount FROM `data_statistics` 
        			WHERE ".$Search_Time_Interval_Sql." AND LinkName != 'Load'
        			AND NowUrl LIKE '%" . $WebDomain['Domain'] ."%'  
        			AND (
        				LinkUrl Like '%Catalog/News%'
        			)
        			GROUP BY LinkUrl,NowUrl ORDER BY LinkCount DESC";
        			$PageName = array('index', 'News', 'Topic', 'Review', 'Watch', 'Knowledge', 'Dictionary');
    			break;
    		}
        	if($this->input->get('aaa') === 'aaa'){
        		    echo 1;
        		    echo $sql;
        		    exit;
    		}
            // 查詢所有頁面結果
			$query = $this->db->query($sql);
		
			$Url = Array();
			foreach($query->result() as $key => $row){
				if(strlen($row->NowUrl) > 0){
					$d = explode('/',rawurldecode(rawurldecode($row->NowUrl)));
					
					// 自動新增既有語系
					if(!in_array($d[1],$Language)) $Language[] = $d[1];

					$page = isset($d[2]) ? $d[2] : 'index';
					$type = isset($d[3]) ? $d[3] : 'index';

					$luArray = explode('://',rawurldecode(rawurldecode($row->LinkUrl)));
					$lu = explode('/', (count($luArray) > 1 ? $luArray[1] : $luArray[0]));
					$lu_type =  isset($lu[3]) ? $lu[3] : 'index';
					if(in_array($type,$PageName)){
						$Url[$d[1]][$type][$lu_type] = isset($Url[$d[1]][$type][$lu_type] ) ? intval($Url[$d[1]][$type][$lu_type]) + intval($row->LinkCount) : $row->LinkCount;
					}
				}
			}

	        foreach($Language as $key => $lg){
				foreach($PageName as $key => $pg){
					if(in_array($pg,$PageName)){
						$TagArray = array();
						$tag_pageSql = $pg == 'index' ? " NowUrl LIKE '%" . $lg . "'" : " NowUrl LIKE '%" . $pg . "%' ";
						$tag_sql = "SELECT LinkName as tag,count(ID) as LinkCount FROM `data_statistics`
						            WHERE UpdateTime > '" . $search_time . "'
						            AND NowUrl LIKE '%" . $WebDomain['Domain'] ."%'
						            AND " . $tag_pageSql ." 
						            AND LinkUrl LIKE '%earch/tag%' 
						            AND NowUrl LIKE '%" . $lg ."%' 
        							AND ".$Search_Time_Interval_Sql."
        							GROUP by LinkName ORDER BY LinkCount DESC";
						$tag_query = $this->db->query($tag_sql);
						foreach($tag_query->result() as $key => $row){
							$TagArray[$key]['Name'] = trim(strip_tags($row->tag));
							$TagArray[$key]['Count'] = $row->LinkCount;
						}
						$Url[$lg][$pg]['tag'] = $TagArray;
					}
				}
			}
			echo json_encode( $Url, JSON_UNESCAPED_UNICODE );
			
			// 存入 API 資料
			$data = array(
				// Domain ID
				'web_domain_ID' => $WebDomain['ID']
				// 建立時間
				, 'UpdateTime' => date('Y-m-d H:i:s')
				// API ID
				, 'API_ID' => 3
				// API 資料查詢 開始時間
				, 'API_Stime' => $Stime
				// API 資料查詢 結束時間
				, 'API_Etime' => $Etime
				// API 資料查詢 
				, 'API_Data' => json_encode( $Url, JSON_UNESCAPED_UNICODE )
			);
			// 寫入 SQL 語法組合 & 跳脫
			$InsertSQL = $this->db->insert_string('api_data', $data);
			// 執行 SQL / 寫入資料
			$this->db->query($InsertSQL);
		}
		
// 		echo json_encode( $data['API_Data'] , JSON_UNESCAPED_UNICODE );
        exit;
	}
	
	
	// Search AD PV Count API
	public function AdPVCount(){

		$data = FALSE;
// 		$source_url_strtotime = strtolower( strval($_SERVER["HTTP_REFERER"]) );
// 		if(!empty($_SERVER["HTTP_REFERER"])){
// 			if ( strpos($source_url_strtotime,strtolower('www.world-wrist-watch.com/zh-Hant/')) !== FALSE ) {
// 	        }
// 		}
		$source_type = NULL;
		
		$get = $this->input->get();
		if(!empty($get)){
	    	$sql = 'SELECT LinkName , COUNT(ID) AS AdCount FROM `data_statistics` 
        	        WHERE UpdateTime >= \''. date("Y-m-d H:i:s",strtotime($get['s'])) .'\' AND UpdateTime < \''. date("Y-m-d H:i:s",strtotime($get['e'])) .'\'
        	        AND LinkType = \'' . $get['type'] . '\'
        	        AND LinkUrl LIKE \'' . rawurldecode($get['url']) . '%\' 
        	        GROUP BY LinkName';
	        $query = $this->db->query($sql);
	        $data = $query->result_array();
		}
	
		echo json_encode( $data, JSON_UNESCAPED_UNICODE );
			exit;
	}
	public function WatchPV()
	{
	    
	   // $this->input->get('d');
	    $day = (int)(empty($this->input->get('d')) ? 1 : $this->input->get('d'));
	   
		$Stime = date('Y-m-d', strtotime('-' . ($day + 1)  . ' days'));
		$Etime = date('Y-m-d', strtotime('-' . $day . ' days'));
	    $sql ="SELECT * FROM (	
    	    SELECT 
            	SUBSTRING_INDEX( URL , '/' , 1) AS brand 
                , SUBSTRING_INDEX( SUBSTRING_INDEX( URL , '/' , 2)  , '/' , -1) AS series 
                , SUBSTRING_INDEX(  SUBSTRING_INDEX( SUBSTRING_INDEX( URL , '/' , 3)  , '/' , -1)  , '?' , 1) AS name 
                , pv
            FROM (
                SELECT SUBSTRING_INDEX( LOWER(NowUrl) , '/watch/' , -1) AS URL
                , COUNT(*) AS pv
                FROM `data_statistics` 
                WHERE web_domain_id = 2 AND index_date >= '" . $Stime . "' AND index_date < '" . $Etime . "' AND LOWER(NowUrl) LIKE '%/watch/%' 
                GROUP BY NowUrl ORDER BY COUNT(*) DESC
            ) AS watch 
            WHERE SUBSTRING_INDEX( URL , '/' , 1) != '' 
            AND SUBSTRING_INDEX( URL , '/' , 1) != SUBSTRING_INDEX( SUBSTRING_INDEX( URL , '/' , 2)  , '/' , -1)
        ) AS watch WHERE brand REGEXP '[[:digit:]]+' = 0";
        
    	$query = $this->db->query($sql); 
    	
    	$data = $query->result_array();
    	foreach($data as $key => $item){
    	    $this->load->database();
    	    $select_sql = 'SELECT * FROM api_watch_pv WHERE index_date = \'' . $Etime . '\' AND brand = \''. rawurldecode($item['brand']) .'\' AND series = \'' . rawurldecode($item['series']) . '\' AND name =\'' . rawurldecode($item['name']) . '\'';
    	    $select_query = $this->db->query($select_sql);
    	    
    	    if($select_query->num_rows() === 0){
                $sql = 'INSERT INTO api_watch_pv (
                		`index_date`
                		,`brand`
                		,`series`
                		,`name`
                		,`pv`
                		) VALUES (
                		\'' . $Etime . '\'
                		,\'' . rawurldecode($item['brand'])  . '\'
                		,\'' . rawurldecode($item['series']) . '\'
                		,\'' . rawurldecode($item['name']) . '\'
                		,\'' . $item['pv'] . '\'
                	)';
                
                if($this->db->query($sql)){
                // echo 'TRUE';
                }
    	        
    	    }
    		$this->db->close();
    	    
    	}
    	
    // 	if(!empty($this->input->get('d'))){
    // 	    echo $day . ':' . count($query->result_array()) .'筆';
    // 	    header('Content-Type: text/html; charset=utf-8');
    // 	    echo '<meta http-equiv="refresh" content="10;url=https://api.starfavour.com/API/WatchPV?d=' . ($day -1) .'"> ';
    // 	}
	exit;
	}
}
